<?php
function usersAdmin()
{
  $ua = new UsersAdmin($this->dbo);
  if(isset($_GET['wtd'])){
    $wtd = $_GET['wtd'];
  }
  else{
    $wtd = 'showList';
  }
  switch($wtd){
    case 'showEditForm':
      $ua->showEditForm('edit');
      break;
    case 'showAddForm':
      $ua->showEditForm('add');
      break;
    case 'showSearchForm':
      $ua->showSearchForm();
      break;
    case 'addUser' :
      $id = 0;
      switch($ua->editUser('add', $id)){
        case ACTION_OK :
          $this->setAdminMessage("Uytkownik zosta dodany (id = $id).");
          break;
        case INVALID_USER_ID:
          $this->setAdminMessage('Nieprawidowy identyfikator uytkownika.');
          break;
        case INVALID_USER_NAME:
          $this->setAdminMessage('Nieprawidowa nazwa uytkownika.');
          break;
        case USER_NAME_ALREADY_EXISTS:
          $this->setAdminMessage('Uytkownik o podanej nazwie istnieje w bazie.');
          break;
        case USER_ID_ALREADY_EXISTS:
          $this->setAdminMessage('Uytkownik o podanym id istnieje w bazie.');
          break;
        case SERVER_ERROR :
        default:
          $this->setAdminMessage('Bd serwera. Uytkownik nie zosta dodany.');
      }
      header('Location:index.php?action=usersAdmin&wtd=showAddForm');
      break;
    case 'modifyUser' :
      $id = 0;
      switch($ua->editUser('edit', $id)){
        case ACTION_OK :
          $this->setAdminMessage('Dane zostay zmienione.');
          break;
        case INVALID_USER_ID:
          $this->setAdminMessage('Nieprawidowy identyfikator uytkownika.');
          break;
        case INVALID_USER_NAME:
          $this->setAdminMessage('Nieprawidowa nazwa uytkownika.');
          break;
        case FORM_DATA_MISSING:
          $this->setAdminMessage('Brak danych z formularza.');
          break;
        case SERVER_ERROR :
        default:
          $this->setAdminMessage('Bd serwera. Danie nie zostay zmienione.');
      }
      header("Location:index.php?action=usersAdmin&wtd=showEditForm&id=$id");
      break;
    case 'searchUser' :
      $ua->showSearchForm();
      switch ($ua->searchUser()){
        case ACTION_OK:
          break;
        case USER_NOT_FOUND:
          echo 'Nie znaleziono uytkownika.';
          break;
        case FORM_DATA_MISSING :
          echo 'Brak danych z formularza.';
          break;
        case INVALID_USER_ID :
          echo 'Bdny identyfikator uytkownika.';
          break;
        case INVALID_USER_NAME :
          echo 'Bdna nazwa uytkownika.';
          break;
        case SERVER_ERROR:
        default:
          echo 'Bd serwera.';
      }
      break;
    case 'deleteUser':
      switch($ua->deleteUser()){
        case ACTION_OK:
          $this->setAdminMessage('Uytkownik zosta usunity.');
          break;
        case USER_NOT_FOUND:
          $this->setAdminMessage('Brak uytkownika o podanym id.');
          break;
        case INVALID_USER_ID:
          $this->setAdminMessage('Nieprawidowy identyfikator uytkownika.');
          break;
        case SERVER_ERROR:
        default:
         $this->setAdminMessage('Bd serwera.');
      }
      header('Location:index.php?action=usersAdmin&wtd=showList');
      break;
    case 'showList' :
    default:
      $ua->showList(ROWS_ON_PAGE);
  }
}
?>